<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Reporte de Ingresos</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 11.5px;
            margin: 30px;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header img {
            height: 60px;
            margin-bottom: 5px;
        }

        .instituto-nombre {
            font-size: 16px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .reporte-titulo {
            font-size: 14px;
            font-weight: bold;
            margin-top: 5px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        thead {
            background-color: #f0f0f0;
        }

        th {
            border: 1px solid #999;
            padding: 6px;
            text-align: center;
            font-weight: bold;
            background-color: #eaeaea;
        }

        td {
            border: 1px solid #ccc;
            padding: 6px;
        }

        tr:nth-child(even) {
            background-color: #fafafa;
        }

        .total {
            font-weight: bold;
            text-align: right;
            padding-top: 10px;
        }

        .footer {
            margin-top: 30px;
            text-align: right;
            font-size: 10px;
            color: #555;
        }
    </style>
</head>
<body>

    <div class="header">
        <?php if($instituto && $instituto->logo): ?>
            <img src="<?php echo e(public_path('storage/' . $instituto->logo)); ?>" alt="Logo">
        <?php endif; ?>
        <div class="instituto-nombre"><?php echo e($instituto->nombre ?? 'INSTITUTO'); ?></div>
        <div class="reporte-titulo">Reporte de Anulaciones</div>
    </div>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Fecha</th>
                <th>Concepto</th>
                <th>Caja</th>
                <th>Monto (S/)</th>
                <th>DNI</th>
                <th>Cliente</th>
                <th>Estado</th>
            </tr>
        </thead>
        <tbody>
            <?php $total = 0; ?>
            <?php $__currentLoopData = $ingresos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $ingreso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $total += $ingreso->monto; ?>
                <tr>
                    <td style="text-align: center;"><?php echo e($i + 1); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($ingreso->fecha)->format('d/m/Y')); ?></td>
                    <td><?php echo e($ingreso->concepto->nombre ?? '-'); ?></td>
                    <td><?php echo e($ingreso->caja->nombre ?? '-'); ?></td>
                    <td style="text-align: right;"><?php echo e(number_format($ingreso->monto, 2)); ?></td>
                    <td><?php echo e($ingreso->dni ?? '-'); ?></td>
                    <td><?php echo e(trim($ingreso->apellidos . ' ' . $ingreso->nombres)); ?></td>
                    <td><?php echo e($ingreso->tipo ?? '-'); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <p class="total">Total Ingresos: <strong>S/ <?php echo e(number_format($total, 2)); ?></strong></p>

    <div class="footer">
        Fecha de generación: <?php echo e(\Carbon\Carbon::now()->format('d/m/Y H:i')); ?>

    </div>

</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/reportes/pdf/anulaciones.blade.php ENDPATH**/ ?>