
<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Inscripciones Observadas <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <div class="table-responsive">
                    
                     

                    <table class="table table-striped mb-0 table-hover" id="tablaInscripciones">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Postulante</th>
                                <th>DNI</th>
                                <th>Plan</th>
                                <th>Admisión</th>
                                <th>Fecha</th>
                                <th>Documentos</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $inscripciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i->id_inscripcion); ?></td>
                                    <td><?php echo e($i->postulante->nombres); ?> <?php echo e($i->postulante->apellidos); ?></td>
                                    <td><?php echo e($i->postulante->dni); ?></td>
                                    <td><?php echo e($i->plan->nombre); ?></td>
                                    <td><?php echo e($i->admision->nombre); ?></td>
                                    <td><?php echo e($i->fecha_registro); ?></td>

                                    <td>
                                        <button class="btn btn-info btn-sm verDocsBtn"
                                                data-postulante='<?php echo json_encode($i->postulante, 15, 512) ?>'>
                                            Ver documentos
                                        </button>
                                    </td>

                                    <td>
                                        <button class="btn btn-success btn-sm cambiarEstado"
                                                data-id="<?php echo e($i->id_inscripcion); ?>"
                                                data-estado="aceptado">Aceptar</button>

                                        <button class="btn btn-warning btn-sm cambiarEstado"
                                                data-id="<?php echo e($i->id_inscripcion); ?>"
                                                data-estado="observado">Observar</button>

                                        <button class="btn btn-danger btn-sm cambiarEstado"
                                                data-id="<?php echo e($i->id_inscripcion); ?>"
                                                data-estado="rechazado">Rechazar</button>
                                    </td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>


<!-- MODAL DOCUMENTOS -->
<div class="modal fade" id="modalDocumentos" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">

        <div class="modal-content">
            <div class="modal-header bg-dark text-white">
                <h5>Documentos del Postulante</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body" id="documentosContenido">

            </div>
        </div>
    </div>
</div>






<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaInscripciones").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaInscripciones_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
$(document).ready(function() {

    $('#tablaInscripciones').DataTable();

    // ================================
    // VER DOCUMENTOS
    // ================================
    $('.verDocsBtn').click(function(){

        let postulante = $(this).data('postulante');

        let html = `
            <ul class="list-group">
                <li class="list-group-item">
                    Foto: 
                    <a target="_blank" href="/${postulante.foto_postulante}">
                        Ver archivo
                    </a>
                </li>

                <li class="list-group-item">
                    Certificado de estudios: 
                    <a target="_blank" href="/${postulante.certificado_estudios}">
                        Ver archivo
                    </a>
                </li>

                <li class="list-group-item">
                    Partida de nacimiento: 
                    <a target="_blank" href="/${postulante.partida_nacimiento}">
                        Ver archivo
                    </a>
                </li>

                <li class="list-group-item">
                    Copia DNI: 
                    <a target="_blank" href="/${postulante.copia_dni}">
                        Ver archivo
                    </a>
                </li>

                <li class="list-group-item">
                    Comprobante de pago: 
                    <a target="_blank" href="/${postulante.comprobante_pago}">
                        Ver archivo
                    </a>
                </li>
            </ul>
        `;

        $('#documentosContenido').html(html);
        $('#modalDocumentos').modal('show');
    });


    // ================================
    // CAMBIAR ESTADO DE INSCRIPCIÓN
    // ================================
    $('.cambiarEstado').click(function () {

        let id = $(this).data('id');
        let estado = $(this).data('estado');

        // Si necesita observación
        if (estado === 'observado') {

            Swal.fire({
                title: "Observación",
                input: "textarea",
                inputLabel: "Ingrese el motivo:",
                inputPlaceholder: "Detalle la observación...",
                inputAttributes: {
                    "aria-label": "Detalle la observación"
                },
                showCancelButton: true,
                confirmButtonText: "Guardar",
                cancelButtonText: "Cancelar"
            }).then((result) => {

                if (result.isConfirmed) {

                    let observacion = result.value;

                    actualizarEstado(id, estado, observacion);
                }
            });

        } else {
            // Confirmación simple para otros estados
            Swal.fire({
                title: "¿Cambiar estado?",
                text: "El estado será cambiado a: " + estado,
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Sí, continuar",
                cancelButtonText: "Cancelar"
            }).then((result) => {
                if (result.isConfirmed) {
                    actualizarEstado(id, estado, null);
                }
            });
        }
    });


    // ==============================================
    // FUNCIÓN AJAX PARA ACTUALIZAR EL ESTADO
    // ==============================================
    function actualizarEstado(id, estado, observacion) {

        $.ajax({
            url: "/inscripciones/cambiar-estado/" + id,
            type: "POST",
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                estado: estado,
                observacion: observacion
            },
            success: function (response) {

                Swal.fire({
                    icon: "success",
                    title: "Actualizado",
                    text: response.message,
                    timer: 1800,
                    showConfirmButton: false
                });

                setTimeout(() => location.reload(), 1500);
            },
            error: function () {
                Swal.fire({
                    icon: "error",
                    title: "Error",
                    text: "No se pudo actualizar el estado."
                });
            }
        });
    }


});
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/inscripciones/observadas.blade.php ENDPATH**/ ?>