@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Registro de Notas: {{ $curso->nombre }} @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
            <div class="mb-3">
                <div class="d-inline-flex align-items-center gap-2">
                        <!-- Botón para agregar nuevo subcomponente -->
                        <a href="{{ route('docente.cursos.informacion', $curso->id) }}" class="btn btn-danger btn-sm me-2">
                            <i class="fas fa-arrow-left"></i> Volver a Información del Curso
                        </a>

                        <button class="btn btn-outline-primary btn-sm mb-3"
        data-bs-toggle="modal"
        data-bs-target="#modalEvaluacionesMoodle"
        data-curso="{{ $curso->id }}">
    <i class="fas fa-cloud-download-alt"></i>
    Importar desde Moodle
</button>

                    </div>
                </div>

                <form id="form-notas" method="POST">
                    <div class="table-responsive">
                        @if ($logros->isEmpty())
                            <!-- CASO 1: Solo nota final -->
                            <table class="table table-bordered text-center table-sm align-middle">
                                <thead class="table-primary">
                                    <tr>
                                        <th>#</th>
                                        <th>Estudiante</th>
                                        <th>Nota Final</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($matriculados as $index => $matriculado)
                                        @php
                                            $estudiante = $matriculado->matricula->postulante;
                                            $notaFinal = $notasFinales[$estudiante->id_postulante]->promedio ?? '';
                                        @endphp
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $estudiante->nombres }} {{ $estudiante->apellidos }}</td>
                                            <td>
                                                <input type="number"
                                                    class="form-control form-control-sm"
                                                    name="nota_final[{{ $matriculado->id }}]"
                                                    min="0" max="20" step="0.01"
                                                    value="{{ $notaFinal }}">
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @else
                            <!-- CASO 2 y 3: Con logros (con o sin subcomponentes) -->
                            <table class="table table-bordered text-center table-sm align-middle">
                                <thead class="table-primary">
                                    <tr>
                                        <th rowspan="2">#</th>
                                        <th rowspan="2">Estudiante</th>
                                        @foreach ($logros as $logro)
                                            <th colspan="{{ $logro->subcomponentes->count() > 0 ? $logro->subcomponentes->count() + 1 : 1 }}">
                                                {{ $logro->nombre }}
                                            </th>
                                        @endforeach
                                        <th rowspan="2">Nota Final</th>
                                    </tr>
                                    <tr>
                                        @foreach ($logros as $logro)
                                            @if ($logro->subcomponentes->count())
                                                @foreach ($logro->subcomponentes as $sub)
                                                    <th>{{ $sub->nombre }}<br><small>({{ $sub->peso }}%)</small></th>
                                                @endforeach
                                                <th>Promedio</th>
                                            @else
                                                <th>Nota</th>
                                            @endif
                                        @endforeach
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($matriculados as $index => $matriculado)
                                        @php
                                            $estudiante = $matriculado->matricula->postulante;
                                        @endphp
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $estudiante->nombres }} {{ $estudiante->apellidos }}</td>

                                            @foreach ($logros as $logroIndex => $logro)
                                                @if ($logro->subcomponentes->count())
                                                    @foreach ($logro->subcomponentes as $sub)
                                                        @php
                                                            $key = $estudiante->id_postulante . '_' . $sub->id;
                                                            $nota = $notasSub[$key][0]->nota ?? '';
                                                        @endphp
                                                        <td>
                                                            <input type="number"
                                                                class="form-control form-control-sm sub"
                                                                data-weight="{{ $sub->peso / 100 }}"
                                                                data-group="logro-{{ $logroIndex }}"
                                                                name="notas[{{ $matriculado->id }}][{{ $sub->id }}]"
                                                                min="0" max="20" step="0.01"
                                                                value="{{ $nota }}">
                                                        </td>
                                                    @endforeach
                                                    @php
                                                        $keyLogro = $estudiante->id_postulante . '_' . $logro->id;
                                                        $notaLogro = $notasLogros[$keyLogro][0]->nota ?? '';
                                                    @endphp
                                                    <td class="logro-total">{{ $notaLogro }}</td>
                                                    <input type="hidden" name="logro_total[{{ $matriculado->id }}][{{ $logro->id }}]" value="{{ $notaLogro }}">
                                                @else
                                                    @php
                                                        $key = $estudiante->id_postulante . '_' . $logro->id;
                                                        $notaLogro = $notasLogros[$key][0]->nota ?? '';
                                                    @endphp
                                                    <td>
                                                        <input type="number"
                                                            class="form-control form-control-sm logro-directo"
                                                            name="logros_directos[{{ $matriculado->id }}][{{ $logro->id }}]"
                                                            min="0" max="20" step="0.01"
                                                            value="{{ $notaLogro }}">
                                                    </td>
                                                @endif
                                            @endforeach

                                            @php
                                                $notaFinal = $notasFinales[$estudiante->id_postulante]->promedio ?? '';
                                            @endphp
                                            <td class="nota-final fw-bold text-primary">{{ $notaFinal }}</td>
                                            <input type="hidden" name="nota_final[{{ $matriculado->id }}]" value="{{ $notaFinal }}">
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    </div>
                    <div class="text-end mt-3">
                        <button type="submit" class="btn btn-success">Guardar Notas</button>
                    </div>
                </form>

            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>



<div class="modal fade" id="modalEvaluacionesMoodle" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">
          <i class="fab fa-moodle"></i> Evaluaciones de Moodle
        </h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <table class="table table-sm table-bordered">
          <thead class="table-light">
            <tr>
              <th>Evaluación</th>
              <th>Tipo</th>
              <th>Máx</th>
              <th>Acción</th>
            </tr>
          </thead>
          <tbody id="tablaEvaluacionesMoodle">
            <tr>
              <td colspan="4" class="text-center text-muted">
                Cargando...
              </td>
            </tr>
          </tbody>
        </table>
      </div>

    </div>
  </div>
</div>



<!-- ===========================
     MODAL: NOTAS EVALUACIÓN MOODLE
     =========================== -->
<div class="modal fade" id="modalNotasEvaluacionMoodle" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">

      <!-- HEADER -->
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">
          <i class="fas fa-list"></i>
          Notas de la evaluación:
          <span id="tituloEvaluacionMoodle"></span>
        </h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <!-- BODY -->
      <div class="modal-body">

        <div class="table-responsive">
          <table class="table table-bordered table-sm align-middle">
            <thead class="table-light">
              <tr>
                <th style="width:40px">#</th>
                <th>Estudiante</th>
                <th class="text-center">Nota Moodle</th>
                <th>Importar en</th>
                <th class="text-center">Máx</th>
              </tr>
            </thead>

            <tbody id="tablaNotasEvaluacionMoodle">
              <tr>
                <td colspan="5" class="text-center text-muted">
                  Cargando notas...
                </td>
              </tr>
            </tbody>
          </table>
        </div>

      </div>

      <!-- FOOTER -->
      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">
          Cerrar
        </button>

        <button class="btn btn-primary" id="btnImportarNotas">
          <i class="fas fa-save"></i> Importar notas
        </button>
      </div>

    </div>
  </div>
</div>



<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- DataTables  -->
<script>
    $(document).ready(function () {
        $("#tablaSubcomponentes").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaSubcomponentes_wrapper .col-md-6:eq(0)');
    });
</script>
<!-- Calculos -->

<script>
    document.addEventListener('input', function (e) {

        // =====================================================
        // CASO 1: LOGROS CON SUBCOMPONENTES
        // =====================================================
        if (e.target.matches('.sub')) {

            const row = e.target.closest('tr');

            const subs = row.querySelectorAll('.sub');
            const logroTotals = row.querySelectorAll('.logro-total');
            const logroTotalInputs = row.querySelectorAll('input[name^="logro_total"]');

            const finalCell = row.querySelector('.nota-final');
            const finalInput = row.querySelector('input[name^="nota_final"]');

            let logroIndex = 0;
            let logroNotas = [];

            for (let i = 0; i < subs.length;) {

                let total = 0;
                let count = 0;

                while (
                    subs[i + count] &&
                    subs[i + count].dataset.group === `logro-${logroIndex}`
                ) {
                    const subInput = subs[i + count];
                    const val = parseFloat(subInput.value) || 0;
                    const weight = parseFloat(subInput.dataset.weight) || 0;

                    total += val * weight;
                    count++;
                }

                const rounded = total.toFixed(2);
                logroNotas.push(parseFloat(rounded));

                if (logroTotals[logroIndex]) {
                    logroTotals[logroIndex].textContent = rounded;
                }

                if (logroTotalInputs[logroIndex]) {
                    logroTotalInputs[logroIndex].value = rounded;
                }

                i += count;
                logroIndex++;
            }

            // Promedio final de logros
            const final = logroNotas.length
                ? (logroNotas.reduce((a, b) => a + b, 0) / logroNotas.length).toFixed(2)
                : '0.00';

            if (finalCell) finalCell.textContent = final;
            if (finalInput) finalInput.value = final;
        }

        // =====================================================
        // CASO 2: LOGROS DIRECTOS (SIN SUBCOMPONENTES)
        // =====================================================
        if (e.target.matches('.logro-directo')) {

            const row = e.target.closest('tr');
            const logros = row.querySelectorAll('.logro-directo');

            const finalCell = row.querySelector('.nota-final');
            const finalInput = row.querySelector('input[name^="nota_final"]');

            let notas = [];

            logros.forEach(input => {
                const val = parseFloat(input.value);
                if (!isNaN(val)) {
                    notas.push(val);
                }
            });

            const final = notas.length
                ? (notas.reduce((a, b) => a + b, 0) / notas.length).toFixed(2)
                : '0.00';

            if (finalCell) finalCell.textContent = final;
            if (finalInput) finalInput.value = final;
        }

    });
</script>

<!-- Agregar -->

<script>
    document.getElementById('form-notas').addEventListener('submit', function (e) {
        e.preventDefault();

        const form = e.target;
        const data = new FormData(form);

        fetch("{{ route('docentes.notas.store', $curso->id) }}", {
            method: "POST",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: data
        })
        .then(response => response.json())
        .then(result => {
            if (result.success) {
                Swal.fire('¡Éxito!', result.message, 'success');
            } else {
                Swal.fire('Error', result.message || 'Ocurrió un error al guardar las notas.', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire('Error', 'Hubo un problema con el envío.', 'error');
        });
    });
</script>

<!-- Ver evaluaciones -->
<script>
    document.getElementById('modalEvaluacionesMoodle').addEventListener('show.bs.modal', function (e) 
    {

        console.log('📌 Modal evaluaciones abierto');

        const cursoId = e.relatedTarget.dataset.curso;
        console.log('📌 Curso Laravel ID:', cursoId);

        const modal = this;
        modal.dataset.cursoActual = cursoId; // 🔥 CLAVE

        const tbody = document.getElementById('tablaEvaluacionesMoodle');
        tbody.innerHTML = `
            <tr>
                <td colspan="4" class="text-center text-muted">
                    Cargando evaluaciones...
                </td>
            </tr>
        `;

        const url = `/docente/curso/${cursoId}/evaluaciones-moodle`;
        console.log('🌐 Fetch URL:', url);

        fetch(url)
            .then(r => r.json())
            .then(res => {

                console.log('📦 Respuesta Moodle:', res);

                if (!res.success) {
                    tbody.innerHTML = `
                        <tr>
                            <td colspan="4" class="text-danger text-center">
                                ${res.message}
                            </td>
                        </tr>
                    `;
                    return;
                }

                if (!res.evaluaciones || res.evaluaciones.length === 0) {
                    tbody.innerHTML = `
                        <tr>
                            <td colspan="4" class="text-center text-muted">
                                No hay evaluaciones calificables en Moodle
                            </td>
                        </tr>
                    `;
                    return;
                }

                tbody.innerHTML = '';

                res.evaluaciones.forEach(ev => {
                    tbody.innerHTML += `
                        <tr>
                            <td>${ev.nombre}</td>
                            <td>${ev.tipo}</td>
                            <td>${ev.max ?? '-'}</td>
                            <td class="text-center">
                                <button
                                    type="button"
                                    class="btn btn-sm btn-outline-primary btn-ver-notas"
                                    data-itemid="${ev.itemid}"
                                    data-nombre="${ev.nombre}"
                                    data-tipo="${ev.tipo}">
                                    <i class="fas fa-eye"></i> Ver notas
                                </button>
                            </td>
                        </tr>
                    `;
                });
            })
            .catch(err => {
                console.error('❌ Error fetch evaluaciones:', err);
                tbody.innerHTML = `
                    <tr>
                        <td colspan="4" class="text-danger text-center">
                            Error al consultar Moodle
                        </td>
                    </tr>
                `;
            });
    });
</script>


<!-- Ver notas de e -->
<script>
    document.addEventListener('click', function (e) {

        const btn = e.target.closest('.btn-ver-notas');
        if (!btn) return;

        const modalEval = document.getElementById('modalEvaluacionesMoodle');

        const cursoId = modalEval.dataset.cursoActual;
        const itemId  = btn.dataset.itemid;
        const nombre  = btn.dataset.nombre;
        const tipo    = btn.dataset.tipo;

        console.log('📌 Ver notas Moodle');
        console.log('➡ Curso ID (Laravel):', cursoId);
        console.log('➡ Item ID (Moodle):', itemId);
        console.log('➡ Tipo:', tipo);

        // 🔴 VALIDACIÓN CRÍTICA
        if (!cursoId || !itemId) {
            Swal.fire({
                icon: 'warning',
                title: 'Datos incompletos',
                text: 'No se pudo identificar la evaluación de Moodle.'
            });
            return;
        }

        // 👉 Setear título del segundo modal (ID CORRECTO)
        const titulo = document.getElementById('tituloEvaluacionMoodle');
        if (titulo) {
            titulo.innerText = nombre;
        }

        // 👉 Abrir segundo modal
        const modalNotas = new bootstrap.Modal(
            document.getElementById('modalNotasEvaluacionMoodle')
        );

        modalNotas.show();

        // 👉 Cargar notas desde Moodle
        cargarNotasEvaluacion(cursoId, itemId);
    });
</script>

<script>
function cargarNotasEvaluacion(cursoId, itemId)
{
    const tbody = document.getElementById('tablaNotasEvaluacionMoodle');

    tbody.innerHTML = `
        <tr>
            <td colspan="5" class="text-center text-muted">
                Cargando notas...
            </td>
        </tr>
    `;

    const url = `/docente/curso/${cursoId}/evaluacion/${itemId}/datos-modal`;
    console.log('🌐 Fetch modal URL:', url);

    fetch(url)
        .then(r => r.json())
        .then(res => {

            console.log('📦 Datos modal:', res);

            if (!res.success) {
                tbody.innerHTML = `
                    <tr>
                        <td colspan="5" class="text-danger text-center">
                            ${res.message ?? 'Error al obtener datos'}
                        </td>
                    </tr>
                `;
                return;
            }

            if (!res.estudiantes || res.estudiantes.length === 0) {
                tbody.innerHTML = `
                    <tr>
                        <td colspan="5" class="text-center text-muted">
                            No hay estudiantes
                        </td>
                    </tr>
                `;
                return;
            }

            tbody.innerHTML = '';

            res.estudiantes.forEach((e, i) => {
                tbody.innerHTML += `
                    <tr>
                        <td>${i + 1}</td>
                        <td>${e.estudiante}</td>
                        <td class="text-center">
                            <span class="fw-bold">${e.nota ?? '-'}</span>
                        </td>
                        <td>
                            ${renderSelectLogros(res.logros, e.userid)}
                        </td>
                        <td class="text-center">—</td>
                    </tr>
                `;
            });
        })
        .catch(err => {
            console.error('❌ Error fetch modal:', err);
            tbody.innerHTML = `
                <tr>
                    <td colspan="5" class="text-danger text-center">
                        Error al consultar Moodle
                    </td>
                </tr>
            `;
        });
}
</script>

<script>
    function renderSelectLogros(logros, estudianteId) {

        let html = `
        <select class="form-select form-select-sm destino-nota"
                data-estudiante="${estudianteId}">
            <option value="">-- Seleccionar destino --</option>
            <option value="final">📘 Nota final del curso</option>
        `;

        logros.forEach(logro => {

            // 👉 OPCIÓN PARA EL LOGRO (SELECCIONABLE)
            html += `
            <option value="logro_${logro.id}">
                🎯 ${logro.nombre}
            </option>
            `;

            // 👉 SUBCOMPONENTES (si existen)
            if (logro.subcomponentes && logro.subcomponentes.length > 0) {

                html += `<optgroup label="↳ ${logro.nombre}">`;

                logro.subcomponentes.forEach(sub => {
                    html += `
                    <option value="sub_${sub.id}">
                        ${sub.nombre}
                    </option>
                    `;
                });

                html += `</optgroup>`;
            }
        });

        html += `</select>`;
        return html;
    }

</script>

<script>
// ===============================
// RENDER SELECT DE LOGROS
// ===============================
function renderSelectLogros(logros, estudianteId) {

    console.log('🎯 renderSelectLogros → estudiante:', estudianteId);
    console.log('🎯 logros:', logros);

    let html = `
    <select class="form-select form-select-sm destino-nota"
            data-estudiante="${estudianteId}">
        <option value="">-- Seleccionar destino --</option>
        <option value="final">📘 Nota final del curso</option>
    `;

    logros.forEach(logro => {

        html += `
        <option value="logro_${logro.id}">
            🎯 ${logro.nombre}
        </option>
        `;

        if (logro.subcomponentes && logro.subcomponentes.length > 0) {

            html += `<optgroup label="↳ ${logro.nombre}">`;

            logro.subcomponentes.forEach(sub => {
                html += `
                <option value="sub_${sub.id}">
                    ${sub.nombre}
                </option>
                `;
            });

            html += `</optgroup>`;
        }
    });

    html += `</select>`;
    return html;
}
</script>

<script>
// ===============================
// CARGAR NOTAS EN EL MODAL
// ===============================
function cargarNotasEvaluacion(cursoId, itemId)
{
    console.log('🚀 cargarNotasEvaluacion');
    console.log('➡ cursoId:', cursoId);
    console.log('➡ itemId:', itemId);

    const tbody = document.getElementById('tablaNotasEvaluacionMoodle');

    tbody.innerHTML = `
        <tr>
            <td colspan="5" class="text-center text-muted">
                Cargando notas...
            </td>
        </tr>
    `;

    const url = `/docente/curso/${cursoId}/evaluacion/${itemId}/datos-modal`;
    console.log('🌐 Fetch URL:', url);

    fetch(url)
        .then(r => r.json())
        .then(res => {

            console.log('📦 Respuesta completa del modal:', res);

            if (!res.success) {
                console.warn('❌ Respuesta sin success');
                return;
            }

            tbody.innerHTML = '';

            res.estudiantes.forEach((e, i) => {

                console.log('👤 Estudiante:', e.estudiante, '→ nota:', e.nota);

                tbody.innerHTML += `
                <tr>
                    <td>${i + 1}</td>
                    <td>${e.estudiante}</td>

                    <!-- 🔥 CELDA CLAVE -->
                    <td class="text-center nota-moodle"
                        data-nota="${e.nota}">
                        <span class="fw-bold">${e.nota ?? '-'}</span>
                    </td>

                    <td>
                        ${renderSelectLogros(res.logros, e.userid)}
                    </td>

                    <td class="text-center">—</td>
                </tr>
                `;
            });

            console.log('✅ Tabla renderizada correctamente');

        })
        .catch(err => {
            console.error('❌ Error fetch datos-modal:', err);
        });
}
</script>

<script>
// ===============================
// IMPORTAR NOTAS
// ===============================
document.getElementById('btnImportarNotas')
.addEventListener('click', function () {

    console.log('💾 Click en Importar Notas');

    const destinos = [];

    document.querySelectorAll('.destino-nota').forEach((sel, index) => {

        console.log(`➡ Select ${index}`, sel);

        if (!sel.value) {
            console.warn('⚠️ Select sin valor, se omite');
            return;
        }

        const fila = sel.closest('tr');
        const celdaNota = fila.querySelector('.nota-moodle');

        console.log('📄 Fila encontrada:', fila);
        console.log('📊 Celda nota:', celdaNota);

        const nota = celdaNota ? celdaNota.dataset.nota : undefined;

        console.log('📝 Nota obtenida:', nota);

        destinos.push({
            estudiante_id: sel.dataset.estudiante,
            destino: sel.value,
            nota: nota
        });
    });

    console.log('📤 PAYLOAD FINAL:', destinos);

    if (destinos.length === 0) {
        Swal.fire({
            icon: 'warning',
            title: 'Atención',
            text: 'Seleccione al menos un destino para importar'
        });
        return;
    }

    Swal.fire({
        title: '¿Importar notas?',
        text: 'Las notas seleccionadas se guardarán en el sistema',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Sí, importar',
        cancelButtonText: 'Cancelar'
    }).then(result => {

        if (!result.isConfirmed) {
            console.warn('🚫 Importación cancelada');
            return;
        }

        const cursoId = document.getElementById('modalEvaluacionesMoodle').dataset.cursoActual;
        const itemId  = document.getElementById('modalNotasEvaluacionMoodle').dataset.itemActual;

        console.log('📡 Enviando a backend → curso:', cursoId, 'item:', itemId);

        fetch(`/docente/curso/${cursoId}/evaluacion/${itemId}/importar-notas`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ destinos })
        })
        .then(r => r.json())
        .then(res => {
            console.log('📥 Respuesta backend:', res);

            if (!res.success) {
                Swal.fire('Error', res.message, 'error');
                return;
            }

            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                text: res.message
            });
        })
        .catch(err => {
            console.error('❌ Error AJAX importar:', err);
            Swal.fire('Error', 'Error al importar notas', 'error');
        });
    });
});
</script>


@endsection
