<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Oferta Laboral</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            line-height: 1.5;
            color: #000;
        }

        h1, h2, h3 {
            margin: 0;
            padding: 0;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .section {
            margin-bottom: 20px;
        }

        .section-title {
            background-color: #f2f2f2;
            padding: 5px;
            font-weight: bold;
            border-bottom: 1px solid #ccc;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        td, th {
            padding: 6px 8px;
            vertical-align: top;
        }

        .bordered td {
            border: 1px solid #ddd;
        }

        .small-text {
            font-size: 11px;
        }

        .label {
            font-weight: bold;
        }

    </style>
</head>
<body>

    <div class="header">
        <h2>OFERTA LABORAL</h2>
        <p><strong><?php echo e($oferta->titulo); ?></strong></p>
    </div>

    
    <div class="section">
        <div class="section-title">Datos Básicos</div>
        <table>
            <tr>
                <td><span class="label">Título:</span></td>
                <td><?php echo e($oferta->titulo); ?></td>
                <td><span class="label">Lugar:</span></td>
                <td><?php echo e($oferta->lugar ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <td><span class="label">Empresa:</span></td>
                <td><?php echo e($oferta->empresa->nombre_empresa ?? 'N/A'); ?></td>
                <td><span class="label">Tipo de Contrato:</span></td>
                <td><?php echo e($oferta->tipoContrato->nombre_tipo_contrato ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <td><span class="label">Fecha de Publicación:</span></td>
                <td><?php echo e(\Carbon\Carbon::parse($oferta->fecha_publicacion)->format('d/m/Y')); ?></td>
                <td><span class="label">Fecha Límite:</span></td>
                <td><?php echo e(\Carbon\Carbon::parse($oferta->fecha_limite)->format('d/m/Y')); ?></td>
            </tr>
            <tr>
                <td><span class="label">Estado:</span></td>
                <td><?php echo e(ucfirst($oferta->estado)); ?></td>
                <td><span class="label">Vacantes:</span></td>
                <td><?php echo e($oferta->vacantes ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <td><span class="label">Remuneración:</span></td>
                <td><?php echo e($oferta->remuneracion ? 'S/ ' . number_format($oferta->remuneracion, 2) : 'N/A'); ?></td>
                <td><span class="label">Plan de Estudio:</span></td>
                <td><?php echo e($oferta->planEstudio->nombre ?? 'N/A'); ?></td>
            </tr>
        </table>
    </div>

    
    <div class="section">
        <div class="section-title">Descripción y Requisitos</div>
        <table class="bordered">
            <tr>
                <td><strong>Descripción:</strong><br><?php echo e($oferta->descripcion); ?></td>
            </tr>
            <?php if($oferta->experiencia): ?>
            <tr>
                <td><strong>Experiencia Requerida:</strong><br><?php echo e($oferta->experiencia); ?></td>
            </tr>
            <?php endif; ?>
            <?php if($oferta->tipo_oferta): ?>
            <tr>
                <td><strong>Tipo de Oferta:</strong><br><?php echo e($oferta->tipo_oferta); ?></td>
            </tr>
            <?php endif; ?>
        </table>
    </div>

    
    <?php if($oferta->pasos_postular): ?>
    <div class="section">
        <div class="section-title">Pasos para Postular</div>
        <p><?php echo e($oferta->pasos_postular); ?></p>
    </div>
    <?php endif; ?>

    
    <?php if($oferta->archivo_pdf): ?>
    <div class="section">
        <div class="section-title">Archivo Adjunto</div>
        <p>Este documento tiene un archivo PDF adicional: <strong><?php echo e($oferta->archivo_pdf); ?></strong></p>
        <p class="small-text">Puedes descargarlo desde el sistema.</p>
    </div>
    <?php endif; ?>

    <div class="section small-text">
        <hr>
        <p>Generado el <?php echo e(\Carbon\Carbon::now()->format('d/m/Y H:i')); ?></p>
    </div>

</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/ofertas_laborales/pdf.blade.php ENDPATH**/ ?>