@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Empresas @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalNuevoTipo">
                    <i class="fas fa-plus"></i> Agregar Nuevo Contrato
                </button>
                <div class="table-responsive">
                    <table id="tablaPeriodos" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>Nombre</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($tipos as $tipo)
                            <tr>
                                <td>{{ $tipo->id_tipo_contrato }}</td>
                                <td>{{ $tipo->nombre_tipo_contrato }}</td>
                                <td>
                                    <span class="badge bg-{{ $tipo->estado == 'Activo' ? 'success' : 'secondary' }}">{{ $tipo->estado }}</span>
                                </td>
                                <td>
                                    <a href="#"data-bs-toggle="modal" data-bs-target="#modalEditarTipo"
                                        data-id="{{ $tipo->id_tipo_contrato }}"
                                        data-nombre="{{ $tipo->nombre_tipo_contrato }}"
                                        data-estado="{{ $tipo->estado }}">
                                        <i class="las la-pen font-18"></i>
                                    </a>
                                    <a href="#" class="text-danger btnEliminar" data-id="{{ $tipo->id_tipo_contrato }}">
                                        <i class="las la-trash-alt font-18"></i>
                                    </a>

                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

{{-- Modal Crear --}}
<div class="modal fade" id="modalNuevoTipo" tabindex="-1" aria-labelledby="modalNuevoTipoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="formNuevoTipo">
            @csrf
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">Nuevo Tipo de Contrato</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label>Nombre</label>
                        <input type="text" class="form-control" name="nombre_tipo_contrato" required>
                    </div>
                    <div class="mb-3">
                        <label>Estado</label>
                        <select class="form-select" name="estado" required>
                            <option value="Activo">Activo</option>
                            <option value="Inactivo">Inactivo</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Guardar</button>
                    <button class="btn btn-secondary" data-bs-dismiss="modal" type="button">Cancelar</button>
                </div>
            </div>
        </form>
    </div>
</div>


{{-- Modal Editar --}}
<div class="modal fade" id="modalEditarTipo" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <form id="formEditarTipo">
            @csrf
            @method('PUT')
            <input type="hidden" id="edit_id_tipo">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">Editar Tipo de Contrato</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label>Nombre</label>
                        <input type="text" class="form-control" name="nombre_tipo_contrato" id="edit_nombre" required>
                    </div>
                    <div class="mb-3">
                        <label>Estado</label>
                        <select class="form-select" name="estado" id="edit_estado" required>
                            <option value="Activo">Activo</option>
                            <option value="Inactivo">Inactivo</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Actualizar</button>
                    <button class="btn btn-secondary" data-bs-dismiss="modal" type="button">Cancelar</button>
                </div>
            </div>
        </form>
    </div>
</div>





<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Tablas CSS -->
<script>
    $(document).ready(function () {
        $("#tablaPeriodos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPeriodos_wrapper .col-md-6:eq(0)');
    });
</script>

<!-- Agregar CSS -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Guardar nuevo tipo
    document.getElementById('formNuevoTipo').addEventListener('submit', function (e) {
        e.preventDefault();
        const form = new FormData(this);

        fetch("{{ route('tipos_contrato.store') }}", {
            method: 'POST',
            headers: { 'X-CSRF-TOKEN': form.get('_token') },
            body: form
        })
        .then(res => res.json())
        .then(data => {
            Swal.fire('Éxito', data.message, 'success');
            $('#modalNuevoTipo').modal('hide');
            setTimeout(() => location.reload(), 1000);
        })
        .catch(() => Swal.fire('Error', 'No se pudo guardar', 'error'));
    });

    // Cargar datos al modal editar
    $('#modalEditarTipo').on('show.bs.modal', function (e) {
        const btn = $(e.relatedTarget);
        $('#edit_id_tipo').val(btn.data('id'));
        $('#edit_nombre').val(btn.data('nombre'));
        $('#edit_estado').val(btn.data('estado'));
    });

    // Editar tipo
    document.getElementById('formEditarTipo').addEventListener('submit', function (e) {
        e.preventDefault();
        const id = document.getElementById('edit_id_tipo').value;
        const form = new FormData(this);

        fetch(`/tipos-contrato/${id}`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': form.get('_token'),
                'X-HTTP-Method-Override': 'PUT'
            },
            body: form
        })
        .then(res => res.json())
        .then(data => {
            Swal.fire('Actualizado', data.message, 'success');
            $('#modalEditarTipo').modal('hide');
            setTimeout(() => location.reload(), 1000);
        })
        .catch(() => Swal.fire('Error', 'No se pudo actualizar', 'error'));
    });

    
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.btnEliminar').forEach(btn => {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            const id = this.getAttribute('data-id');

            Swal.fire({
                title: '¿Estás seguro?',
                text: "Esta acción no se puede deshacer.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(`/tipos-contrato/${id}`, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'X-HTTP-Method-Override': 'DELETE',
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    })
                    .then(res => res.json())
                    .then(data => {
                        Swal.fire('Eliminado', data.message, 'success');
                        setTimeout(() => location.reload(), 1000);
                    })
                    .catch(() => {
                        Swal.fire('Error', 'No se pudo eliminar el tipo de contrato.', 'error');
                    });
                }
            });
        });
    });
});
</script>



@endsection
