<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Certificado extends Model
{
    use HasFactory;

    protected $table = 'certificados';

    protected $fillable = [
        'postulante_id',
        'modulo_id',
        'plan_estudio_id',
    ];

    // Relaciones
    public function postulante()
    {
        return $this->belongsTo(Postulante::class, 'postulante_id', 'id_postulante');
    }

    public function modulo()
    {
        return $this->belongsTo(ModuloFormativo::class, 'modulo_id', 'id_modulo');
    }

    public function planEstudio()
    {
        return $this->belongsTo(PlanEstudio::class, 'plan_estudio_id');
    }
}
