<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Postulante extends Model
{
    use HasFactory;

    protected $table = 'postulantes';
    // Especificar la clave primaria si no es 'id'
    protected $primaryKey = 'id_postulante';
    public $incrementing = true;
    protected $keyType = 'int';
    protected $fillable = [
        'codigo_postulante',
        'nombres',
        'apellidos',
        'dni',
        'email',
        'telefono',
        'genero',
        'fecha_nacimiento',
        'lengua_materna',
        'foto_postulante',
        'direccion',
        'usuario_id',
        'id_colegio',
        'año_egreso',
        'discapacidad',
        'nombre_discapacidad',
        'fecha_registro',
        'certificado_estudios',
        'partida_nacimiento',
        'comprobante_pago',
        'copia_dni',
        'id_medio_pago',
        'fuente_inscripcion',
        'curriculum_archivo',
        'grado',
    ];

    public function usuario()
    {
        return $this->belongsTo(Usuario::class, 'usuario_id');
    }

    public function colegio()
    {
        return $this->belongsTo(Colegio::class, 'id_colegio');
    }

    public function medioPago()
    {
        return $this->belongsTo(MedioPago::class, 'id_medio_pago');
    }

    public function matriculas()
    {
        return $this->hasMany(Matricula::class, 'postulante_id', 'id_postulante');
    }

    public function notasLogros()
    {
        return $this->hasMany(NotaLogro::class, 'estudiante_id', 'id_postulante');
    }

    public function notasFinales()
    {
        return $this->hasMany(NotaFinal::class, 'estudiante_id', 'id_postulante');
    }

    public function getNombreCompletoAttribute()
{
    return "{$this->apellidos}, {$this->nombres}";
}



}
