<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Docentes <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
            <div class="card mb-4">
            <form id="formPerfil" method="POST">
    <?php echo csrf_field(); ?>

    
    <div class="card mb-4 shadow-sm border-0">
        <div class="card-header bg-primary text-white">
            <i class="bi bi-person-circle me-2"></i>Datos Personales
        </div>
        <div class="card-body">

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="nombre" class="form-label"><i class="bi bi-person-fill"></i> Nombre</label>
                    <input type="text" name="nombre" value="<?php echo e(old('nombre', $docente->nombre)); ?>" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label for="apellido" class="form-label"><i class="bi bi-person-lines-fill"></i> Apellido</label>
                    <input type="text" name="apellido" value="<?php echo e(old('apellido', $docente->apellido)); ?>" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label for="dni" class="form-label"><i class="bi bi-credit-card-2-front-fill"></i> DNI</label>
                    <input type="text" name="dni" value="<?php echo e($docente->dni); ?>" class="form-control" readonly>
                </div>

                <div class="col-md-6">
                    <label for="email" class="form-label"><i class="bi bi-envelope-fill"></i> Email</label>
                    <input type="email" name="email" value="<?php echo e(old('email', $docente->email)); ?>" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label for="telefono" class="form-label"><i class="bi bi-telephone-fill"></i> Teléfono</label>
                    <input type="text" name="telefono" value="<?php echo e(old('telefono', $docente->telefono)); ?>" class="form-control">
                </div>

                <div class="col-md-6">
                    <label for="direccion" class="form-label"><i class="bi bi-geo-alt-fill"></i> Dirección</label>
                    <input type="text" name="direccion" value="<?php echo e(old('direccion', $docente->direccion)); ?>" class="form-control">
                </div>

                
            </div>

        </div>
    </div>

    
    <div class="card mb-4 shadow-sm border-0">
        <div class="card-header bg-secondary text-white">
            <i class="bi bi-key-fill me-2"></i>Cambiar Contraseña
        </div>
        <div class="card-body">

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="password" class="form-label"><i class="bi bi-lock-fill"></i> Nueva Contraseña</label>
                    <input type="password" name="password" id="password" class="form-control">
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-md-6">
                    <label for="password_confirmation" class="form-label"><i class="bi bi-lock"></i> Confirmar Contraseña</label>
                    <input type="password" name="password_confirmation" id="password_confirmation" class="form-control">
                </div>
            </div>

        </div>
    </div>

    <div class="text-end">
        <button type="submit" class="btn btn-success px-4">
            <i class="bi bi-save-fill me-1"></i> Guardar Cambios
        </button>
    </div>
</form>

                
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>


<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


<script>
document.getElementById('formPerfil').addEventListener('submit', function(e) {
    e.preventDefault();

    let form = this;
    let formData = new FormData(form);

    fetch("<?php echo e(route('docente.actualizar-perfil')); ?>", {
        method: "POST",
        headers: {
            'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
        },
        body: formData
    })
    .then(response => {
        if (!response.ok) throw response;
        return response.json();
    })
    .then(data => {
        Swal.fire({
            icon: 'success',
            title: 'Éxito',
            text: data.message || 'Perfil actualizado correctamente'
        });
    })
    .catch(async error => {
        let msg = 'Ocurrió un error al guardar';

        if (error.status === 422) {
            const err = await error.json();
            msg = Object.values(err.errors).flat().join('\n');
        }

        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: msg
        });
    });
});
</script>









<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestp-sanluis.dedu.pe/resources/views/docentes/perfil.blade.php ENDPATH**/ ?>