<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Modulos Formativos <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalNuevoModulo">
                    <i class="fas fa-plus"></i> Agregar Modulo Formativo
                </button>

                <!-- Filtros -->
                <form action="<?php echo e(route('modulo_formativos.index')); ?>" method="GET" class="mb-3">
                    <div class="row g-2 align-items-end">
                        <div class="col-md-4">
                            <label for="plan_estudio_id" class="form-label">Plan de Estudio</label>
                            <select name="plan_estudio_id" id="plan_estudio_id" class="form-select form-select-sm">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $planesEstudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($plan->id); ?>" <?php echo e(request()->plan_estudio_id == $plan->id ? 'selected' : ''); ?>>
                                        <?php echo e($plan->nombre); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-3 d-flex gap-2">
                            <button type="submit" class="btn btn-primary btn-sm w-50">
                                <i class="fas fa-filter"></i> Filtrar
                            </button>
                            <a href="<?php echo e(route('modulo_formativos.index')); ?>" class="btn btn-secondary btn-sm w-50">
                                <i class="fas fa-sync-alt"></i> Limpiar
                            </a>
                        </div>
                    </div>
                </form>


                <div class="table-responsive">
                

                    <table id="tablaModulos" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>N° Módulo</th>
                                <th>Plan de Estudio</th>
                                <th>Horas</th>
                                <th>Creditos</th>
                                <th>Fecha Registro</th>
                                <th>Fecha Actualización</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $modulos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modulo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($modulo->id_modulo); ?></td>
                                    <td><?php echo e($modulo->nombre); ?></td>
                                    <td><?php echo e($modulo->num_modulo); ?></td>
                                    <td><?php echo e($modulo->planEstudio->nombre ?? 'Sin asignar'); ?></td>
                                    <td><?php echo e($modulo->horas); ?></td>
                                    <td><?php echo e($modulo->creditos); ?></td>
                                    <td><?php echo e($modulo->fecha_registro); ?></td>
                                    <td><?php echo e($modulo->fecha_actualizacion); ?></td>
                                    <td>
                                        <!-- Editar -->
                                        <a href="#" 
                                            class="text-warning"
                                            data-bs-toggle="modal" 
                                            data-bs-target="#editModuloModal"
                                            data-id="<?php echo e($modulo->id_modulo); ?>"
                                            data-nombre="<?php echo e($modulo->nombre); ?>"
                                            data-num_modulo="<?php echo e($modulo->num_modulo); ?>"
                                            data-plan="<?php echo e($modulo->id_plan_estudio); ?>"
                                            data-horas="<?php echo e($modulo->horas); ?>"
                                            data-creditos="<?php echo e($modulo->creditos); ?>">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>


                                    <!-- Eliminar -->
                                        <form action="<?php echo e(route('modulo_formativos.destroy', $modulo->id_modulo)); ?>" method="POST" class="delete-form" style="display:inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-link" style="border: none; background: none;">
                                                <i class="las la-trash-alt text-secondary font-18"></i>
                                            </button>
                                        </form>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>


                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<div class="modal fade" id="modalNuevoModulo" tabindex="-1" aria-labelledby="modalNuevoModuloLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalNuevoModuloLabel">Agregar Nuevo Módulo Formativo</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <form id="formNuevoModulo" action="<?php echo e(route('modulo_formativos.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre del Módulo</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                    </div>

                    <div class="mb-3">
                        <label for="num_modulo" class="form-label">Número de Módulo</label>
                        <input type="number" class="form-control" id="num_modulo" name="num_modulo" required>
                    </div>

                    <div class="row">
                        <div class="mb-3 col-md-6">
                            <label for="horas" class="form-label">Horas</label>
                            <input type="number" class="form-control" id="horas" name="horas" required>
                        </div>

                        <div class="mb-3 col-md-6">
                            <label for="creditos" class="form-label">Créditos</label>
                            <input type="number" class="form-control" id="creditos" name="creditos" required>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="id_plan_estudio" class="form-label">Plan de Estudio</label>
                        <select class="form-select" id="id_plan_estudio" name="id_plan_estudio" required>
                            <option value="" selected disabled>Seleccione un plan</option>
                            <?php $__currentLoopData = $planesEstudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-primary">Guardar Módulo</button>
                </form>
            </div>
        </div>
    </div>
</div>





<!-- Modal de Edición -->
<!-- Modal Editar Módulo -->
<div class="modal fade" id="editModuloModal" tabindex="-1" aria-labelledby="editModuloModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModuloModalLabel">Editar Módulo Formativo</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <form id="formEditarModulo" action="<?php echo e(route('modulo_formativos.update', 'id')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre del Módulo</label>
                        <input type="text" class="form-control" id="edit_nombre" name="nombre" required>
                    </div>

                    <div class="mb-3">
                        <label for="num_modulo" class="form-label">Número de Módulo</label>
                        <input type="number" class="form-control" id="edit_num_modulo" name="num_modulo" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_horas" class="form-label">Horas</label>
                        <input type="number" class="form-control" id="edit_horas" name="horas" required>
                    </div>

                    <div class="mb-3">
                        <label for="edit_creditos" class="form-label">Créditos</label>
                        <input type="number" class="form-control" id="edit_creditos" name="creditos" required>
                    </div>


                    <div class="mb-3">
                        <label for="id_plan_estudio" class="form-label">Plan de Estudio</label>
                        <select class="form-select" id="edit_id_plan_estudio" name="id_plan_estudio" required>
                            <option value="" selected disabled>Seleccione un plan</option>
                            <?php $__currentLoopData = $planesEstudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-primary">Actualizar Módulo</button>
                </form>
            </div>
        </div>
    </div>
</div>





<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaModulos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaModulos_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $(document).ready(function() {
        $('#formNuevoModulo').on('submit', function(e) {
            e.preventDefault();  // Prevenir el envío tradicional del formulario

            // Obtener los datos del formulario
            var formData = new FormData(this);

            // Realizar la solicitud AJAX
            $.ajax({
                url: '<?php echo e(route('modulo_formativos.store')); ?>',  // La ruta para guardar el módulo
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    // Verificar si la respuesta es exitosa
                    if (response.success) {
                        // Mostrar alerta de éxito
                        Swal.fire({
                            icon: 'success',
                            title: 'Módulo guardado exitosamente!',
                            text: response.message,
                            confirmButtonText: 'Cerrar',
                        }).then(() => {
                            // Cerrar el modal
                            $('#modalNuevoModulo').modal('hide');
                            // Limpiar el formulario
                            $('#formNuevoModulo')[0].reset();
                            // Recargar la página para reflejar los cambios
                            location.reload();
                        });
                    } else {
                        // Mostrar alerta de error
                        Swal.fire({
                            icon: 'error',
                            title: '¡Error!',
                            text: response.message,
                            confirmButtonText: 'Cerrar',
                        });
                    }
                },
                error: function(xhr, status, error) {
                    // Mostrar alerta de error si algo falla
                    Swal.fire({
                        icon: 'error',
                        title: '¡Error!',
                        text: 'Ocurrió un error al guardar el módulo. Intenta nuevamente.',
                        confirmButtonText: 'Cerrar',
                    });
                }
            });
        });
    });
</script>

<script>
    // Llenar el modal para editar el periodo
    $('#editModuloModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var moduloId = button.data('id');
        var nombre = button.data('nombre');
        var numModulo = button.data('num_modulo');
        var planEstudioId = button.data('plan');
        var horas = button.data('horas');
        var creditos = button.data('creditos');

        var modal = $(this);
        modal.find('#edit_nombre').val(nombre);
        modal.find('#edit_num_modulo').val(numModulo);
        modal.find('#edit_id_plan_estudio').val(planEstudioId);
        modal.find('#edit_horas').val(horas);
        modal.find('#edit_creditos').val(creditos);

        var actionUrl = "<?php echo e(route('modulo_formativos.update', ':id')); ?>";
        actionUrl = actionUrl.replace(':id', moduloId);
        modal.find('#formEditarModulo').attr('action', actionUrl);
    });


    // Llenar el modal para editar el módulo formativo
    $('#editModuloModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget); // Botón que activó el modal
        var moduloId = button.data('id'); // Extraer el ID del módulo
        var nombre = button.data('nombre');
        var numModulo = button.data('num_modulo');
        var planEstudioId = button.data('plan');

        // Rellenar los campos del modal con los datos del módulo
        var modal = $(this);
        modal.find('#edit_nombre').val(nombre);
        modal.find('#edit_num_modulo').val(numModulo);
        modal.find('#edit_id_plan_estudio').val(planEstudioId);

        // Cambiar la URL del formulario para apuntar al módulo específico
        var actionUrl = "<?php echo e(route('modulo_formativos.update', ':id')); ?>";
        actionUrl = actionUrl.replace(':id', moduloId);
        modal.find('#formEditarModulo').attr('action', actionUrl);
    });

    // Enviar la solicitud AJAX para actualizar el módulo
    $('#formEditarModulo').on('submit', function (e) {
        e.preventDefault();

        // Mostrar alerta de carga mientras se procesa
        Swal.fire({
            title: 'Actualizando...',
            text: 'Estamos actualizando el módulo',
            showConfirmButton: false,
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // Hacer la solicitud AJAX
        $.ajax({
            url: $(this).attr('action'),
            method: 'POST',
            data: $(this).serialize(),
            success: function (response) {
                if (response.success) {
                    // Mostrar mensaje de éxito con SweetAlert
                    Swal.fire({
                        icon: 'success',
                        title: '¡Módulo Actualizado!',
                        text: response.message,
                        showConfirmButton: false,
                        timer: 1500,
                    }).then(() => {
                        // Cerrar el modal
                        $('#editModuloModal').modal('hide');
                        // Recargar la página para reflejar los cambios
                        location.reload();
                    });
                } else {
                    // Mostrar mensaje de error con SweetAlert
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message,
                        showConfirmButton: true,
                    });
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                // Si ocurre algún error en la solicitud AJAX
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Hubo un problema al actualizar el módulo.',
                    showConfirmButton: true,
                });
            }
        });
    });
</script>

<script>
    // Eliminar módulo con AJAX y SweetAlert
    $(document).on('submit', '.delete-form', function (e) {
        e.preventDefault(); // Evitar el envío normal del formulario

        var form = $(this);
        var url = form.attr('action'); // URL del formulario

        // Confirmación con SweetAlert antes de eliminar
        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡Este módulo será eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                // Mostrar mensaje de carga
                Swal.fire({
                    title: 'Eliminando...',
                    text: 'Estamos eliminando el módulo',
                    showConfirmButton: false,
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                // Realizar la solicitud AJAX
                $.ajax({
                    url: url,
                    method: 'POST',
                    data: form.serialize(),
                    success: function (response) {
                        // Si la eliminación es exitosa
                        Swal.fire({
                            icon: 'success',
                            title: '¡Módulo Eliminado!',
                            text: 'El módulo ha sido eliminado correctamente.',
                            showConfirmButton: false,
                            timer: 1500
                        }).then(() => {
                            // Recargar la página para reflejar los cambios
                            location.reload();
                        });
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        // Si ocurre un error en la solicitud AJAX
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Hubo un problema al eliminar el módulo.',
                            showConfirmButton: true
                        });
                    }
                });
            }
        });
    });

</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestp-sanluis.dedu.pe/resources/views/modulo_formativos/index.blade.php ENDPATH**/ ?>