<table id="tablaPeriodos" class="table table-bordered table-striped">
    <thead>
        <tr>
            <th>Título</th>
            <th>Empresa</th>
            <th>Plan de estudio</th>
            <th>Fecha publicación</th>
            <th>Vacantes</th>
            <th>Postulantes</th>
        </tr>
    </thead>
    <tbody>
        @forelse($ofertas as $oferta)
        <tr>
            <td>{{ $oferta->titulo }}</td>
            <td>{{ $oferta->empresa->nombre_empresa ?? '---' }}</td>
            <td>{{ $oferta->planEstudio->nombre ?? '---' }}</td>
            <td>{{ $oferta->fecha_publicacion }}</td>
            <td>{{ $oferta->vacantes }}</td>
            <td>
                <a href="{{ route('ofertas.verPostulantes', $oferta->id_oferta) }}" class="btn btn-sm btn-info" target="_blank">
                    Ver postulantes
                </a>

            </td>
        </tr>
        @empty
        <tr>
            <td colspan="6" class="text-center">No se encontraron resultados con los filtros seleccionados.</td>
        </tr>
        @endforelse
    </tbody>
</table>

