<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Ofertas <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Ofertas Vencidas -  <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">

                

                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3" 
                    data-bs-toggle="modal" 
                    data-bs-target="#modalReporteVencidas">
                    <i class="fas fa-plus"></i> Reporte Ofertas Vencidas
                </button>

                
                <div class="table-responsive">
                    <table id="tablaPeriodos" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>#</th>
                                <th>Título</th>
                                <th>Empresa</th>
                                <th>Tipo de Contrato</th>
                                <th>Plan de Estudio</th>
                                <th>Fecha Publicación</th>
                                <th>Fecha Límite</th>
                                <th>Estado</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $ofertasVencidas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $oferta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($i + 1); ?></td>
                                <td><?php echo e($oferta->titulo); ?></td>
                                <td><?php echo e($oferta->empresa->nombre_empresa ?? 'N/A'); ?></td>
                                <td><?php echo e($oferta->tipoContrato->nombre_tipo ?? 'N/A'); ?></td>
                                <td><?php echo e($oferta->planEstudio->nombre_plan ?? 'N/A'); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($oferta->fecha_publicacion)->format('d/m/Y')); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($oferta->fecha_limite)->format('d/m/Y')); ?></td>
                                <td><?php echo e(ucfirst($oferta->estado)); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center">No hay ofertas vencidas.</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    
                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>


<div class="modal fade" id="modalReporteVencidas" tabindex="-1" aria-labelledby="modalReporteVencidasLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" id="formReporteVencidas" target="_blank">
        <?php echo csrf_field(); ?>
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Reporte de Ofertas Vencidas</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Fecha de inicio</label>
                    <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Fecha de fin</label>
                    <input type="date" name="fecha_fin" id="fecha_fin" class="form-control" required>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Generar PDF</button>
            </div>
        </div>
    </form>


  </div>
</div>








<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPeriodos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPeriodos_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('formReporteVencidas');
    form.addEventListener('submit', function (e) {
        e.preventDefault();

        const fechaInicio = document.getElementById('fecha_inicio').value;
        const fechaFin = document.getElementById('fecha_fin').value;

        if (!fechaInicio || !fechaFin) {
            alert('Completa ambas fechas.');
            return;
        }

        // Creamos un formulario temporal para enviar por POST
        const tempForm = document.createElement('form');
        tempForm.method = 'POST';
        tempForm.action = "<?php echo e(route('ofertas.reporte.vencidas')); ?>";
        tempForm.target = '_blank';

        const csrf = document.createElement('input');
        csrf.type = 'hidden';
        csrf.name = '_token';
        csrf.value = '<?php echo e(csrf_token()); ?>';
        tempForm.appendChild(csrf);

        const inputInicio = document.createElement('input');
        inputInicio.type = 'hidden';
        inputInicio.name = 'fecha_inicio';
        inputInicio.value = fechaInicio;
        tempForm.appendChild(inputInicio);

        const inputFin = document.createElement('input');
        inputFin.type = 'hidden';
        inputFin.name = 'fecha_fin';
        inputFin.value = fechaFin;
        tempForm.appendChild(inputFin);

        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);

        // Oculta el modal
        const modal = bootstrap.Modal.getInstance(document.getElementById('modalReporteVencidas'));
        if (modal) {
            modal.hide();
        }
    });
});
</script>





<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/ofertas_laborales/vencidas.blade.php ENDPATH**/ ?>