<!-- Modal centrado -->
<div class="modal fade" id="modalOferta<?php echo e($oferta->id_oferta); ?>" tabindex="-1" aria-labelledby="modalLabel<?php echo e($oferta->id_oferta); ?>" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalLabel<?php echo e($oferta->id_oferta); ?>"><?php echo e($oferta->titulo); ?></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <!-- Columna izquierda -->
                    <div class="col-md-6">
                        <p><strong>Empresa:</strong> <?php echo e($oferta->empresa->nombre_empresa ?? 'Empresa desconocida'); ?></p>
                        <p><strong>Fecha de Publicación:</strong> <?php echo e(\Carbon\Carbon::parse($oferta->fecha_publicacion)->format('d/m/Y')); ?></p>
                        <p><strong>Fecha Límite:</strong> <?php echo e($oferta->fecha_limite ? \Carbon\Carbon::parse($oferta->fecha_limite)->format('d/m/Y') : 'No especificada'); ?></p>
                        <p><strong>Lugar:</strong> <?php echo e($oferta->lugar ?? 'No especificado'); ?></p>
                        <p><strong>Tipo de Contrato:</strong> <?php echo e($oferta->tipoContrato->nombre_tipo_contrato ?? 'No definido'); ?></p>
                        <p><strong>Tipo de Oferta:</strong> <?php echo e($oferta->tipo_oferta ?? 'No especificado'); ?></p>
                        <p><strong>Remuneración:</strong> <?php echo e($oferta->remuneracion ? 'S/ ' . number_format($oferta->remuneracion, 2) : 'No especificada'); ?></p>
                        <p><strong>Vacantes:</strong> <?php echo e($oferta->vacantes ?? 'No especificado'); ?></p>
                        <p><strong>Estado:</strong> 
                            <?php switch($oferta->estado):
                                case ('aceptado'): ?> <span class="badge bg-success">Aceptado</span> <?php break; ?>
                                <?php case ('pendiente'): ?> <span class="badge bg-warning text-dark">Pendiente</span> <?php break; ?>
                                <?php case ('rechazado'): ?> <span class="badge bg-danger">Rechazado</span> <?php break; ?>
                                <?php default: ?> <span class="badge bg-secondary">Desconocido</span>
                            <?php endswitch; ?>
                        </p>
                        <?php if($oferta->archivo_pdf && file_exists(public_path($oferta->archivo_pdf))): ?>
                            <a href="<?php echo e(asset($oferta->archivo_pdf)); ?>" target="_blank" class="btn btn-outline-info btn-sm mt-2">
                                Ver Documento PDF <i class="fas fa-file-pdf ms-1"></i>
                            </a>
                        <?php endif; ?>
                    </div>

                    <!-- Columna derecha -->
                    <div class="col-md-6">
                        <p><strong>Experiencia:</strong></p>
                        <div class="border p-2 rounded bg-light mb-3" style="min-height: 100px;">
                            <?php echo nl2br(e($oferta->experiencia ?? 'No especificado')); ?>

                        </div>

                        <p><strong>Requisitos:</strong></p>
                        <div class="border p-2 rounded bg-light mb-3" style="min-height: 100px;">
                            <?php echo nl2br(e($oferta->requisitos ?? 'No especificado')); ?>

                        </div>

                        <p><strong>Pasos para Postular:</strong></p>
                        <div class="border p-2 rounded bg-light" style="min-height: 100px;">
                            <?php echo nl2br(e($oferta->pasos_postular ?? 'No especificado')); ?>

                        </div>
                    </div>
                </div>
            </div>

           <?php
    $curriculumPath = $postulante?->curriculum_archivo;
?>

<div class="modal-footer">
    <?php if(!empty($curriculumPath)): ?>
        <button class="btn btn-success btn-postular" data-id="<?php echo e($oferta->id_oferta); ?>">
            <i class="fas fa-paper-plane me-1"></i> Postular
        </button>
    <?php else: ?>
        <button class="btn btn-secondary" disabled>
            <i class="fas fa-ban me-1"></i> No puedes postular sin haber subido tu currículum
        </button>
    <?php endif; ?>

    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cerrar</button>
</div>




        </div>
    </div>
</div>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/estudiantes/ofertas/partials/modal_oferta.blade.php ENDPATH**/ ?>