<?php

namespace App\Http\Controllers;

use App\Models\Instituto;
use App\Models\Departamento;
use App\Models\Provincia;
use App\Models\Distrito;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
class InstitutoController extends Controller
{
    /**
     * Mostrar el formulario para registrar o editar el instituto.
     */
    public function index()
    {
        $instituto = Instituto::first(); // Solo debe haber uno
        $departamentos = Departamento::all();
        $provincias = Provincia::all();
        $distritos = Distrito::all();
        return view('instituto.index', compact('instituto','departamentos', 'provincias', 'distritos'));
    }

    /**
     * Guardar un nuevo instituto.
     */

     public function show($id)
{
    $instituto = Instituto::findOrFail($id);
    return view('instituto.show', compact('instituto'));
}
    public function store(Request $request)
{
    $request->validate([
        'nombre' => 'required|string|max:100',
        'direccion' => 'nullable|string|max:255',
        'telefono' => 'nullable|string|max:20',
        'logo' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
        'codigo_modular' => 'nullable|string|max:20',
        'dre' => 'nullable|string|max:20',
        'nombre_departamento' => 'nullable|string|max:100',
        'nombre_provincia' => 'nullable|string|max:100',
        'nombre_distrito' => 'nullable|string|max:100',
    ]);

    $data = $request->only([
        'nombre', 'direccion', 'telefono', 'codigo_modular', 'dre',
        'nombre_departamento', 'nombre_provincia', 'nombre_distrito'
    ]);

    // Renombramos para coincidir con los campos de la tabla `instituto`
    $data['departamento'] = $request->input('nombre_departamento');
    $data['provincia'] = $request->input('nombre_provincia');
    $data['distrito'] = $request->input('nombre_distrito');

    if ($request->hasFile('logo')) {
        $logo = $request->file('logo');
        $nombreLogo = time() . '_' . $logo->getClientOriginalName();
        $directorio = public_path('storage/logos');

        // Crear carpeta si no existe
        if (!file_exists($directorio)) {
            mkdir($directorio, 0755, true);
        }

        // Mover el archivo
        $logo->move($directorio, $nombreLogo);

        // Ruta relativa para guardar en la BD
        $data['logo'] = 'logos/' . $nombreLogo;
    }

    Instituto::create($data);

    return redirect()->route('instituto.index')->with('success', 'Instituto registrado correctamente.');
}

    public function edit($id)
    {
        $instituto = Instituto::findOrFail($id);
    
        return response()->json($instituto);
    }
    

    /**
     * Actualizar los datos del instituto.
     */
    public function update(Request $request, $id)
    {
        $instituto = Instituto::findOrFail($id);
    
        $request->validate([
            'nombre' => 'required|string|max:100',
            'direccion' => 'nullable|string|max:255',
            'telefono' => 'nullable|string|max:20',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'codigo_modular' => 'nullable|string|max:20',
            'dre' => 'nullable|string|max:20',
            'departamento' => 'nullable|string|max:20',
            'provincia' => 'nullable|string|max:20',
            'distrito' => 'nullable|string|max:20',
        ]);
    
        $data = $request->except('logo');
    
        if ($request->hasFile('logo')) {
            $logo = $request->file('logo');
            $nombreLogo = time() . '_' . $logo->getClientOriginalName();
            $directorio = public_path('storage/logos');
    
            // Crear carpeta si no existe
            if (!file_exists($directorio)) {
                mkdir($directorio, 0755, true);
            }
    
            // Eliminar logo anterior si existe
            if ($instituto->logo && file_exists(public_path('storage/' . $instituto->logo))) {
                unlink(public_path('storage/' . $instituto->logo));
            }
    
            // Mover el nuevo logo
            $logo->move($directorio, $nombreLogo);
    
            // Guardar nueva ruta
            $data['logo'] = 'logos/' . $nombreLogo;
        }
    
        $instituto->update($data);
    
        return redirect()->route('instituto.index')->with('success', 'Instituto actualizado correctamente.');
    }
    

    public function obtenerProvincias($departamentoId)
    {
        $provincias = Provincia::where('idDepa', $departamentoId)->get();
        return response()->json($provincias);
    }

    public function obtenerDistritos($provinciaId)
    {
        $distritos = Distrito::where('idProv', $provinciaId)->get();
        return response()->json($distritos);
    }
}
