@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Administrativo @endslot
@slot('title') Módulos @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <div class="table-responsive">
                    <table id="tablaModulos" class="table table-striped mb-0 table-hover">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Descripción</th>
                            
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($modulos as $modulo)
                        <tr>
                            <td>{{ $modulo->id }}</td>
                            <td>{{ $modulo->nombre }}</td>
                            <td>{{ $modulo->descripcion }}</td>
                            
                        </tr>
                        @endforeach
                    </tbody>
                </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>






<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaModulos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaModulos_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $(document).ready(function () {
        $("#formNuevoPeriodo").submit(function (event) {
            event.preventDefault(); // Evita el envío tradicional del formulario

            $.ajax({
                url: "{{ route('periodos.store') }}", // Ruta que maneja la creación del período
                method: "POST",
                data: $(this).serialize(), // Serializa los datos del formulario
                success: function (response) {
                    Swal.fire({
                        title: "¡Éxito!",
                        text: "Período agregado correctamente.",
                        icon: "success",
                        confirmButtonText: "OK"
                    }).then(() => {
                        location.reload(); // Recargar la página para mostrar el nuevo período en la tabla
                    });
                },
                error: function (xhr) {
                    Swal.fire({
                        title: "Error",
                        text: "Hubo un problema al agregar el período.",
                        icon: "error",
                        confirmButtonText: "Entendido"
                    });
                }
            });
        });
    });
</script>

<script>
    $('#editModal').on('show.bs.modal', function (event) {
    var button = $(event.relatedTarget); // Botón que activó el modal
    var id = button.data('id');
    var nombre = button.data('nombre');
    var descripcion = button.data('descripcion');
    var fecha_inicio = button.data('fecha_inicio');
    var fecha_fin = button.data('fecha_fin');
    var activo = button.data('activo');

    var modal = $(this);
    modal.find('.modal-title').text('Editar Periodo ' + nombre);
    modal.find('#nombre').val(nombre);
    modal.find('#descripcion').val(descripcion);
    modal.find('#fecha_inicio').val(fecha_inicio);
    modal.find('#fecha_fin').val(fecha_fin);
    modal.find('#activo').val(activo);

    // Cambiar la URL del formulario con el ID del periodo
    modal.find('form').attr('action', '/periodos/' + id);
});

// Aquí el script para enviar el formulario con AJAX y mostrar SweetAlert
$('#editForm').on('submit', function (e) {
    e.preventDefault(); // Evitar el envío estándar del formulario

    var form = $(this);
    var actionUrl = form.attr('action');
    var formData = form.serialize();

    $.ajax({
        url: actionUrl,
        method: 'POST',
        data: formData,
        success: function (response) {
            Swal.fire({
                icon: 'success',
                title: '¡Éxito!',
                text: 'Periodo actualizado exitosamente.',
                confirmButtonText: 'OK'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.reload(); // Recargar la página después de éxito
                }
            });
        },
        error: function (xhr) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Ocurrió un error al actualizar el periodo. Intenta nuevamente.',
                confirmButtonText: 'OK'
            });
        }
    });
});

</script>

@endsection
