@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Unidades Didacticas @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <a href="{{ route('cursos.create') }}" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3">
                    <i class="fas fa-plus"></i> Agregar Unidad Didáctica
                </a>


                <!-- Filtros -->
                <form id="filtroCursos" action="{{ route('cursos.index') }}" method="GET" class="mb-3">
                    <div class="row g-2 align-items-end">
                        <!-- Nombre del curso -->
                        <div class="col-md-3">
                            <label for="nombre" class="form-label">Nombre del Curso</label>
                            <input type="text" name="nombre" id="nombre" class="form-control form-control-sm" 
                                value="{{ request('nombre') }}" placeholder="Buscar por nombre">
                        </div>

                        <!-- Plan de Estudio -->
                        <div class="col-md-3">
                            <label for="plan_estudio_id" class="form-label">Plan de Estudio</label>
                            <select name="plan_estudio_id" id="plan_estudio_id" class="form-select form-select-sm">
                                <option value="">Todos</option>
                                @foreach($planesEstudio as $plan)
                                    <option value="{{ $plan->id }}" {{ request()->plan_estudio_id == $plan->id ? 'selected' : '' }}>
                                        {{ $plan->nombre }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Semestre -->
                        <div class="col-md-2">
                            <label for="semestre_id" class="form-label">Semestre</label>
                            <select name="semestre_id" id="semestre_id" class="form-select form-select-sm">
                                <option value="">Todos</option>
                                @foreach($semestres as $semestre)
                                    <option value="{{ $semestre->id }}" {{ request()->semestre_id == $semestre->id ? 'selected' : '' }}>
                                        {{ $semestre->nombre }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Módulo -->
                        <div class="col-md-2">
                            <label for="modulo_id" class="form-label">Módulo Formativo</label>
                            <select name="modulo_id" id="modulo_id" class="form-select form-select-sm">
                                <option value="">Todos</option>
                                @foreach($modulos as $modulo)
                                    <option value="{{ $modulo->id_modulo }}" {{ request()->modulo_id == $modulo->id_modulo ? 'selected' : '' }}>
                                        {{ $modulo->nombre }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Botones -->
                        <div class="col-md-2 d-flex gap-2">
                            <button type="submit" class="btn btn-primary btn-sm w-50">
                                <i class="fas fa-filter"></i> Filtrar
                            </button>
                            <a href="{{ route('cursos.index') }}" class="btn btn-secondary btn-sm w-50">
                                <i class="fas fa-sync-alt"></i> Limpiar
                            </a>
                        </div>
                    </div>
                </form>



                <div class="table-responsive">
                
                <table id="tablaCursos" class="table table-striped mb-0 table-hover">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Tipo</th>
                            <th>Módulo</th>
                            <th>Plan de Estudio</th>
                            <th>Semestre</th>
                            <th>Créditos</th>
                            <th>Horas</th>
                            
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($cursos as $curso)
                            <tr>
                                <td>{{ $curso->id }}</td>
                                <td>{{ $curso->nombre }}</td>
                                <td>{{ $curso->tipo }}</td>
                                <td>{{ $curso->modulo->nombre ?? 'Sin asignar' }}</td>
                                <td>
                                    @foreach ($curso->cursosPlanEstudios as $rel)
                                        <span class="badge bg-primary">{{ $rel->planEstudio->nombre }}</span>
                                    @endforeach
                                </td>
                                <td>{{ $curso->semestre->nombre ?? 'Sin asignar' }}</td>
                                <td>{{ $curso->creditos }}</td>
                                <td>{{ $curso->horas_semestrales }}</td>
                               
                                <td>
                                    <!-- Editar -->
                                    <a href="{{ route('cursos.edit', $curso->id) }}" class="text-warning">
                                        <i class="las la-pen text-secondary font-18"></i>
                                    </a>

                                    <!-- Eliminar -->
                                   <button 
                                        class="btn btn-link p-0 btn-delete-curso"
                                        data-id="{{ $curso->id }}">
                                        <i class="las la-trash-alt text-secondary font-18"></i>
                                    </button>

                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>







<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaCursos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaCursos_wrapper .col-md-6:eq(0)');
    });
</script>


<script>
    $(document).ready(function () {
        $('#filtroCursos').on('submit', function (e) {
            e.preventDefault();

            $.ajax({
                url: $(this).attr('action'),
                method: 'GET',
                data: $(this).serialize(),
                success: function (response) {
                    $('#tablaCursos tbody').html(response); // ✅ Solo cambiamos las filas
                },
                error: function () {
                    alert('Ocurrió un error al filtrar los cursos.');
                }
            });
        });
    });
</script>

<script>
document.addEventListener('click', function (e) {

    if (e.target.closest('.btn-delete-curso')) {

        const button = e.target.closest('.btn-delete-curso');
        const cursoId = button.dataset.id;

        Swal.fire({
            title: '¿Eliminar curso?',
            text: 'Esta acción no se puede deshacer',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
        }).then((result) => {

            if (result.isConfirmed) {

                fetch(`/cursos/${cursoId}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json',
                    }
                })
                .then(response => response.json())
                .then(data => {

                    if (data.success) {
                        Swal.fire('Eliminado', data.message, 'success')
                            .then(() => location.reload());
                    } else {
                        Swal.fire('No permitido', data.message, 'error');
                    }

                })
                .catch(() => {
                    Swal.fire('Error', 'Error al eliminar el curso', 'error');
                });
            }
        });
    }
});
</script>




@endsection
